/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.breakpoints;

import frc.emul.api.engine.IEngineBreakpoint;
import frc.emul.api.engine.IEngineBreakpointListener;
import frc.emul.api.engine.IEngineBreakpointManager;
import frc.emul.api.engine.IMobileBreakpoint;
import frc.emul.vectrex.Vectrex;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectrexBreakpointManager
implements IEngineBreakpointManager,
PropertyChangeListener {
    private final List<IEngineBreakpointListener> ears = new ArrayList<IEngineBreakpointListener>();
    private final List<IEngineBreakpoint> breakpoints = new ArrayList<IEngineBreakpoint>();
    private Vectrex core;

    public VectrexBreakpointManager() {
    }

    public VectrexBreakpointManager(Vectrex vectrex) {
        this.setCore(vectrex);
    }

    public void setCore(Vectrex vectrex) {
        if (this.core != null) {
            this.core.setBreakpointManager(null);
        }
        this.core = vectrex;
        if (this.core != null) {
            this.core.setBreakpointManager(this);
        }
    }

    @Override
    public void addBreakpointListener(IEngineBreakpointListener iEngineBreakpointListener) {
        this.ears.add(iEngineBreakpointListener);
    }

    @Override
    public void removeBreakpointListener(IEngineBreakpointListener iEngineBreakpointListener) {
        this.ears.remove(iEngineBreakpointListener);
    }

    @Override
    public boolean isEmpty() {
        return this.breakpoints.isEmpty();
    }

    @Override
    public int getCount() {
        return this.breakpoints.size();
    }

    @Override
    public synchronized IEngineBreakpoint checkForHit() {
        int n = this.breakpoints.size();
        while (n-- > 0) {
            IEngineBreakpoint iEngineBreakpoint = this.breakpoints.get(n);
            if (!iEngineBreakpoint.evaluate(this.core)) continue;
            if (iEngineBreakpoint instanceof IMobileBreakpoint) {
                ((IMobileBreakpoint)((Object)iEngineBreakpoint)).setHitPC(this.core.getCPU().getLastPC());
            }
            return iEngineBreakpoint;
        }
        return null;
    }

    @Override
    public synchronized void setBreakpoints(List<IEngineBreakpoint> list) {
        this.breakpoints.clear();
        this.breakpoints.addAll(list);
        this.breakpointsChanged();
    }

    @Override
    public synchronized void clearBreakpoints() {
        for (IEngineBreakpoint iEngineBreakpoint : this.breakpoints) {
            iEngineBreakpoint.removePropertyChangeListener(this);
        }
        this.breakpoints.clear();
        this.breakpointsChanged();
    }

    @Override
    public synchronized void resetBreakpoints() {
        int n = this.breakpoints.size();
        while (--n >= 0) {
            this.breakpoints.get(n).reset(this.core);
        }
    }

    @Override
    public synchronized void add(IEngineBreakpoint iEngineBreakpoint) {
        if (!iEngineBreakpoint.isTemporary()) {
            iEngineBreakpoint.addPropertyChangeListener(this);
        }
        this.breakpoints.add(iEngineBreakpoint);
        this.breakpointAdded(iEngineBreakpoint);
    }

    @Override
    public synchronized boolean remove(IEngineBreakpoint iEngineBreakpoint) {
        if (this.breakpoints.remove(iEngineBreakpoint)) {
            iEngineBreakpoint.removePropertyChangeListener(this);
            this.breakpointRemoved(iEngineBreakpoint);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void removeTemporaryBreakpoints() {
        int n = this.breakpoints.size();
        while (--n >= 0) {
            if (!this.breakpoints.get(n).isTemporary()) continue;
            this.breakpoints.remove(n);
        }
    }

    @Override
    public synchronized List<IEngineBreakpoint> getBreakpoints() {
        return new ArrayList<IEngineBreakpoint>(this.breakpoints);
    }

    @Override
    public synchronized List<IEngineBreakpoint> getBreakpoints(int n) {
        ArrayList<IEngineBreakpoint> arrayList = new ArrayList<IEngineBreakpoint>(4);
        int n2 = this.breakpoints.size();
        while (--n2 >= 0) {
            if (this.breakpoints.get(n2).getAddress() != n) continue;
            arrayList.add(this.breakpoints.get(n2));
        }
        return arrayList;
    }

    @Override
    public synchronized List<IEngineBreakpoint> getBreakpoints(boolean bl) {
        ArrayList<IEngineBreakpoint> arrayList = new ArrayList<IEngineBreakpoint>(4);
        int n = this.breakpoints.size();
        while (--n >= 0) {
            if (this.breakpoints.get(n).isTemporary() != bl) continue;
            arrayList.add(this.breakpoints.get(n));
        }
        return arrayList;
    }

    @Override
    public synchronized List<IEngineBreakpoint> getBreakpoints(Class<?> clazz) {
        if (clazz == null) {
            return this.getBreakpoints();
        }
        ArrayList<IEngineBreakpoint> arrayList = new ArrayList<IEngineBreakpoint>(4);
        int n = this.breakpoints.size();
        while (--n >= 0) {
            if (!clazz.isAssignableFrom(this.breakpoints.get(n).getClass())) continue;
            arrayList.add(this.breakpoints.get(n));
        }
        return arrayList;
    }

    @Override
    public synchronized IEngineBreakpoint getBreakpoint(int n) {
        int n2 = this.indexOf(n);
        return n2 < 0 ? null : this.fetchIndex(n2);
    }

    @Override
    public synchronized IEngineBreakpoint getBreakpoint(int n, boolean bl) {
        int n2 = this.breakpoints.size();
        while (--n2 >= 0) {
            IEngineBreakpoint iEngineBreakpoint = this.breakpoints.get(n2);
            if (iEngineBreakpoint.getAddress() != n || iEngineBreakpoint.isTemporary() != bl) continue;
            return iEngineBreakpoint;
        }
        return null;
    }

    @Override
    public synchronized IEngineBreakpoint getBreakpoint(int n, Class<?> clazz) {
        if (clazz == null) {
            return this.getBreakpoint(n);
        }
        int n2 = this.breakpoints.size();
        while (--n2 >= 0) {
            IEngineBreakpoint iEngineBreakpoint = this.breakpoints.get(n2);
            if (iEngineBreakpoint.getAddress() != n || !clazz.isAssignableFrom(iEngineBreakpoint.getClass())) continue;
            return iEngineBreakpoint;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof IEngineBreakpoint) {
            IEngineBreakpoint iEngineBreakpoint = (IEngineBreakpoint)object;
            if ("address".equals(propertyChangeEvent.getPropertyName())) {
                this.remove(iEngineBreakpoint);
                this.add(iEngineBreakpoint);
            }
            this.breakpointModified(iEngineBreakpoint);
        }
    }

    private IEngineBreakpoint fetchIndex(int n) {
        return this.breakpoints.get(n);
    }

    private synchronized int indexOf(int n) {
        int n2 = this.breakpoints.size();
        while (--n2 >= 0) {
            if (n != this.breakpoints.get(n2).getAddress()) continue;
            return n2;
        }
        return -1;
    }

    private final void breakpointsChanged() {
        for (IEngineBreakpointListener iEngineBreakpointListener : this.ears) {
            iEngineBreakpointListener.breakpointsListChanged(this);
        }
    }

    private final void breakpointRemoved(IEngineBreakpoint iEngineBreakpoint) {
        if (!iEngineBreakpoint.isTemporary()) {
            for (IEngineBreakpointListener iEngineBreakpointListener : this.ears) {
                iEngineBreakpointListener.breakpointDeleted(iEngineBreakpoint);
            }
        }
    }

    private final void breakpointAdded(IEngineBreakpoint iEngineBreakpoint) {
        if (!iEngineBreakpoint.isTemporary()) {
            for (IEngineBreakpointListener iEngineBreakpointListener : this.ears) {
                iEngineBreakpointListener.breakpointCreated(iEngineBreakpoint);
            }
        }
    }

    private final void breakpointModified(IEngineBreakpoint iEngineBreakpoint) {
        if (!iEngineBreakpoint.isTemporary()) {
            for (IEngineBreakpointListener iEngineBreakpointListener : this.ears) {
                iEngineBreakpointListener.breakpointModified(iEngineBreakpoint);
            }
        }
    }
}

